package gov.va.med.mhv.admin.web.validator;

import java.util.ResourceBundle;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value="employeeSearchValidator")
public class EmployeeSearchValidator implements Validator {
	
	@Override
	public void validate(FacesContext context, UIComponent component,
			Object value) throws ValidatorException {

		String vaNetworkId = null;
		String lastName = null;
		
		HtmlInputText vaNetworkIdValue = (HtmlInputText)component.getAttributes().get("vaNetworkId");
		HtmlInputText lastNameValue = (HtmlInputText)component.getAttributes().get("lastName");
		
		if (vaNetworkIdValue != null && vaNetworkIdValue.getValue() != null) {
			vaNetworkId = (String) vaNetworkIdValue.getValue();
		}
		
		if (lastNameValue != null && lastNameValue.getValue() != null) {
			lastName = (String) lastNameValue.getValue();
		}
		
		// fail validation if certain conditions are not met
		if ((vaNetworkId == null || vaNetworkId.isEmpty()) && (lastName == null || lastName.isEmpty())) {
			ResourceBundle bundle = ResourceBundle.getBundle("labels.messages", FacesContext.getCurrentInstance().getViewRoot().getLocale());
			throw new ValidatorException(new FacesMessage(
					FacesMessage.SEVERITY_ERROR, 
					bundle.getString("searchFormCriteriaErrorHeader"),""));
		}
		
	}

}
